/**
 * @file Drv_SIM.c
 * @author 吳星萍 iris@e-besthealth.com
 * @brief SIM0 SIM1 驅動程序
 * @version 0.1
 * @date 2020-06-17
 *
 * @copyright BEST HEALTH ELECTRONIC INC (c) 2019
 *
 * Compiler Ver. : V3.57
 * IDE3000  Ver. : V8.03
 * MCU/CFG  Ver. : BH67F5362/1.1
 */
#include "Project_Global.h"
#include "BH67F5362.h"
#include "Drv_SIM.h"
#include "Drv_GPIO.h"

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 變量定義 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
volatile SIM_STRUCT SIM_Data;

/**
 * @brief SIM 上電初始化
 *
 */
void Drv_SIM_PowerOn()
{
#ifdef SIM_MODE_IIC
	SET_PA5_SCK_SCL();
	SET_PA4_SDI_SDA();
	_sima = SIM_IIC_ADDRESS;
	_simc0 = 0xc4; 			
	_simc1 = 0x02;		    
	_simtoc = (SIM_IIC_TIMEOUT << 7) + SIM_IIC_TIMEOUT_PERIOD;
	_simen = 1;_simf = 0;_sime = 1;
#endif
#ifdef SIM_MODE_SPI
	SET_SIM_SPI_PIN();
//	_simc0 =0xa0; 			//SPI從機模式
	_simc0 =0x00;			//SPI主機模式，時鐘為Fsys/4
	_simc2 = (SIM_SPI_CLOCK_EDGE << 4) + (SIM_SPI_DATA_MLS << 3) +( SIM_SPI_CSEN_PIN << 2);
	_simen = 1;_simf = 0;_sime = 1;
#endif
    _mf3f=0;
    _mf3e=1;
   	_emi = 1;
}
/**
 * @brief SIM 休眠初始化
 *
 */
void Drv_SIM_PowerDown()
{

#ifdef SIM_MODE_IIC
	_simen = 0;
	_sime = 0; _simf = 0;
#endif
#ifdef SIM_MODE_SPI
	_simen = 0;
	_sime = 0; _simf = 0;
#endif
}

///********************************************************************
//Function: SIM
//INPUT	:
//OUTPUT:
//NOTE	: SPI/IIC 二選一
//********************************************************************/
DEFINE_ISR(SIM_ISR, SIM_VECTOR)
{

#ifdef SIM_MODE_IIC
	_simf=0;	
	if (_simtof)		// TimeOut溢出中斷
	{
		_simtof  = 0;
		_simtoen = 1;	// reset TimerOut
		_iamwu   = 1;
		SIM_Data.RxOffset = 0;
		SIM_Data.TxOffset = 0;
	}
	else
	{
		if(_haas && _srw)	// addres match and IIC tx mode
		{
			_htx = 1;		// config SLAVE TO TX
			SIM_Data.TxOffset = 0;
			_simd = SIM_Data.TxBuf[SIM_Data.TxOffset];
			SIM_Data.TxOffset++;
		}
		else if (_haas && !_srw)	// addres match and IIC rx mode
		{
			_htx      = 0; 		// config SLAVE TO RX
			_txak     = 0;		// SET ACK signal
			SIM_Data.RxBuf[SIM_Data.RxOffset] = _simd;	// Dummy read from SIMD to release SCL line
			SIM_Data.RxOffset++;
			
//			if(SIM_Data.RxOffset >= 3)
//			{
//				SIM_Data.RxOffset = 0;
//			}
		}
		else if (!_haas && _htx)	// addres not match and IIC tx mode
		{
			if(_rxak)
			{//rxak=1:主機停止拒絕接受下個字節，發出停止信號
				_htx  = 0;
				_txak = 0;
				_acc  = _simd;		//虛度數值釋放總線
			}
			else					//發送數據
			{
				_simd = SIM_Data.TxBuf[SIM_Data.TxOffset];
				SIM_Data.TxOffset ++;
				if (SIM_Data.TxOffset >3)
				{
					SIM_Data.TxOffset = 0;
				}
			}
		}
		else if (!_haas && !_htx)	// addres not match and IIC rx mode
		{
			SIM_Data.RxBuf[SIM_Data.RxOffset] = _simd;
			SIM_Data.RxOffset++;
			if (SIM_Data.RxOffset > 3)
			{
				SIM_Data.RxOffset = 0;
				SIM_Data.flag.b.RxIsOK = 1;
			}
		}
	}
#endif
#ifdef SIM_MODE_SPI
	if (_trf)					//發送/接受結束標誌位
	{
		SIM_Data.RxBuf[SIM_Data.RxOffset] = _simd;
		SIM_Data.RxOffset ++;
		_trf = 0;
		do
		{
			_wcol = 0;
			
			_simd = SIM_Data.TxBuf[SIM_Data.TxOffset];
			SIM_Data.TxOffset ++;
			if (SIM_Data.RxOffset >= TXBUF_LENGTH)
			{
				SIM_Data.RxOffset = 0;
				SIM_Data.TxOffset = 0;
				SIM_Data.flag.b.RxIsOK = 1;
			}
		} while (_wcol);

    }
#endif
}
/********************************************************************
Function: Drv_SIMSPI_TxRxByte
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
unsigned char Drv_SIMSPI_TxRxByte(unsigned char txData)
{
	do{
		_wcol = 0;
		GCC_CLRWDT();
		_simd = txData;
	}
	while(_wcol);
	while(!_trf)
	{
		GCC_CLRWDT();
	}
	_trf = 0;
	return _simd;
}

void Drv_SIMSPI_TxRxBuf(unsigned char len, volatile unsigned char* txBuf)
{
	unsigned char i=0;
	for(i=0;i<len;i++)
	{
		SIM_Data.RxBuf[i]=Drv_SIMSPI_TxRxByte(*(txBuf+i));
		_simf=0;
	}
}